<?php
namespace push;
/**
 * 极光推送
 * @Author: Administrator
 * @Date:   2020/2/20
 * @Last Modified by:   WL
 * @Last Modified time: 10:09
 */
require_once __DIR__ . '/lib/jpush/autoload.php';
use \JPush\Client;
class Jpush implements Appointment
{
    //@see  https://github.com/jpush/jpush-api-php-client/blob/master/doc/api.md#init-api

    /**
     * 推送key
     * @var string $app_key
     */
    protected $app_key = null;

    /**
     * 推送secret
     * @var string $secret
     */
    protected $secret = null;

    /**
     * 日志路径,传null不记录
     * @var string $log_path
     */
    protected $log_path = null;

    /**
     * 表示 APNs 是否生产环境，True 表示推送生产环境，False 表示要推送开发环境；如果不指定则默认为推送开发环境
     * @var boolean $apns;
     */
    protected $apns = false;

    /**
     * 推送绑定参数
     * @var array $params
     */
    protected $params = [];

    /**
     * 实例化极光类
     * @var object $client
     */
    protected $client = null;

    /**
     * 初始化推送
     * @param string $app_key
     * @param string $master_secret
     * @param null $log_path
     * @return Jpush
     */
    public final function init(string $app_key, string $master_secret)
    {
        $this->app_key = $app_key;
        $this->secret = $master_secret;
        is_null($this->client) && $this->client = new Client($this->app_key, $this->secret, null);
        return $this;
    }

    /**
     * 绑定推送参数
     * @param string $platform 目标用户终端手机的平台类型android,ios,winphone。默认全部平台推送(参数可选)
     * @param string|array $alias 绑定的极光推送(别名)
     * @param string|array $tags 绑定的极光推送(标签名)
     * @param string|array $tags_and 绑定的极光推送(标签名,取交集)(参数可选)
     * @param string|array $tags_not 绑定的极光推送(标签名,取补集)(参数可选)
     * @param string|array $register_id 注册时极光返回的唯一身份标识(参数可选)
     * @param string $title 表示通知标题，会替换通知里原来展示 App 名称的地方
     * @param string $content 推送的内容。
     * @param array $extend 根据业务逻辑自定义参数(参数可选)
     * @param boolean $send_msg 是否推送消息,默认不推送(参数可选)
     * @return Jpush
     */
    public function params(array $params)
    {
        $this->params['platform'] = $params['platform'] ?? 'all';
        $this->params['alias'] = $params['alias'];
        $this->params['tags']  = $params['tags'];
        $this->params['tags_and']  = $params['tags_and'] ?? [];
        $this->params['tags_not']  = $params['tags_not'] ?? [];
        $this->params['register_id']  = $params['register_id'] ?? [];
        $this->params['notification'] = [
            "alert" => $params['content'],
            "android" => [
                "title" => $params['title'],
                "builder_id" => 1,
                "alert" => $params['content'],
                "extras"=> $params['extend'] ?? []
            ],
            "ios" => [
                "badge" => "+1",
                "alert" => $params['content'],
                "sound" => "default",
                "extras" => $params['extend'] ?? []
            ]
        ];
        $this->params['message'] = [];
        $this->params['message']['msg_content'] = [];
        if(!empty($params['send_msg']))
        {
            $this->params['message'] = [
                "title" => $params['title'],
                "msg_content" => $params['content'],
                "extras" => $params['extend'] ?? []
            ];
        }
        return $this;
    }

    //推送
    public function push() : array
    {
        try {
            $push = $this->client->push();
            $response = $push->setPlatform($this->params['platform'])
                             ->addAlias($this->params['alias'])
                             ->addTag($this->params['tags'])
                             ->addTagAnd($this->params['tags_and'])
                             ->addTagNot($this->params['tags_not'])
                             ->addRegistrationId($this->params['register_id'])
                             ->iosNotification($this->params['notification']['alert'],$this->params['notification']['ios'])
                             ->androidNotification($this->params['notification']['alert'],$this->params['notification']['android'])
                             ->message($this->params['message']['msg_content'],$this->params['message'])
                             ->options(["sendno" => time(), "apns_production" => $this->apns])
                             ->send();
            return ['status' => 1, 'data' => $response, 'msg' => '推送成功'];
        }catch (\Client\Exceptions\JPushException $e){
            return ['status' => 0, 'msg' => $e->getMessage()];
        }
    } 
}