<?php
namespace push;
/**
 * @Author: Administrator
 * @Date:   2020/2/20
 * @Last Modified by:   WL
 * @Last Modified time: 10:04
 */
class Push implements \ArrayAccess
{
    /**
     * 对象池
     * @var array $push
     */
    public $push = [
        'Jpush' => Jpush::class,
    ];

    /**
     * 对象容器
     * @var object $container
     */
    public $container = null;

    public function __call($name, $arguments)
    {
        if(!isset($this->push[$name]))
        {
            throw new \Exception('对象不存在');
        }

        if(!isset($this->container[$name]))
        {
            $class = new \ReflectionClass($this->push[$name]);
            $instance  = $class->newInstanceArgs();
            $this->container[$name] = $instance;
        }
        return $this->container[$name];
    }

    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    public function offsetGet($offset)
    {
        if(!isset($this->push[$offset]))
        {
            throw new \Exception('对象不存在');
        }

        if(!isset($this->container[$offset]))
        {
            $class = new \ReflectionClass($this->push[$offset]);
            $instance  = $class->newInstanceArgs();
            $this->container[$offset] = $instance;
        }
        return $this->container[$offset];
    }

    public function offsetSet($offset, $value)
    {
        return $this->container[$offset] = $value;
    }

    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }
}